<?php
// /home/bungalowsepeti/public_html/panel/sidebar.php

$u = current_user();
$isAdmin = (($u['rol'] ?? '') === 'admin');
$current = basename($_SERVER['PHP_SELF'] ?? '');

$active = function(array $files) use ($current): string {
  return in_array($current, $files, true) ? ' is-active' : '';
};

$open = function(array $files) use ($current): string {
  return in_array($current, $files, true) ? ' is-open' : '';
};

$tesisAdi = trim((string)($u['tesis_ismi'] ?? ''));
if ($tesisAdi === '') $tesisAdi = 'Kullanıcı';

$kredi = (int)($u['kredi_puani'] ?? 0);
$profilFoto = trim((string)($u['profil_fotografi'] ?? ''));

$initial = 'U';
if ($tesisAdi !== '') {
  if (function_exists('mb_substr') && function_exists('mb_strtoupper')) {
    $initial = mb_strtoupper(mb_substr($tesisAdi, 0, 1, 'UTF-8'), 'UTF-8');
  } else {
    $initial = strtoupper(substr($tesisAdi, 0, 1));
  }
}

$grpIlan = ['ilanlarim.php','ilan-ekle.php','one-cikar.php'];
$grpKredi = ['kredi-yonetimi.php','faturalar.php'];
$grpAyar = ['ayarlar.php','ilan-ayarlari.php','tesis-listesi.php','tesis-ayarlari.php'];

$isIlanOpen = in_array($current, $grpIlan, true);
$isKrediOpen = in_array($current, $grpKredi, true);
$isAyarOpen = in_array($current, $grpAyar, true);
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="/panel/css/panel.css?v=1">
<script src="/panel/js/sidebar.js?v=1"></script>
<script src="/panel/js/toast.js?v=2" defer></script>
<script src="/panel/js/popup.js?v=2" defer></script>
<script src="/panel/js/upload.js?v=2" defer></script>

<aside class="sidebar" id="sidebar" aria-label="Panel Menü" aria-hidden="false">
  <div class="sidebar-top">
    <a class="sidebar-logo" href="index.php">
      <span class="sidebar-logo-mark">BS</span>
      <span class="sidebar-logo-text">Bungalov Sepeti</span>
    </a>

    <button class="sidebar-toggle sidebar-opener js-sidebar-toggle" type="button" aria-controls="sidebar" aria-label="Menüyü aç" aria-expanded="false">
  <i class="bi bi-list" aria-hidden="true"></i>
</button>

<button class="sidebar-toggle sidebar-close js-sidebar-toggle" type="button" aria-label="Menüyü kapat" aria-controls="sidebar" aria-expanded="true">
  <i class="bi bi-x-lg" aria-hidden="true"></i>
</button>

  </div>

  <nav class="sidebar-nav" role="navigation">
    <a class="nav-item<?= $active(['index.php']) ?>" href="index.php">
      <span class="nav-ico"><i class="bi bi-house-door" aria-hidden="true"></i></span><span class="nav-text">Anasayfa</span>
    </a>

    <a class="nav-item<?= $active(['ortam-kutuphanesi.php']) ?>" href="ortam-kutuphanesi.php">
      <span class="nav-ico"><i class="bi bi-images" aria-hidden="true"></i></span><span class="nav-text">Ortam Kütüphanesi</span>
    </a>

    <a class="nav-item<?= $active(['uyelik-bilgilerim.php']) ?>" href="uyelik-bilgilerim.php">
      <span class="nav-ico"><i class="bi bi-person-circle" aria-hidden="true"></i></span><span class="nav-text">Üyelik Bilgilerim</span>
    </a>

    <div class="nav-group<?= $open($grpIlan) ?>">
      <button class="nav-group-btn" type="button" aria-expanded="<?= $isIlanOpen ? 'true' : 'false' ?>">
        <span class="nav-ico"><i class="bi bi-pin-angle" aria-hidden="true"></i></span><span class="nav-text">İlan Yönetimi</span><span class="nav-caret"><i class="bi bi-chevron-down" aria-hidden="true"></i></span>
      </button>
      <div class="nav-sub">
        <a class="nav-sub-item<?= $active(['ilanlarim.php']) ?>" href="ilanlarim.php">
          <span class="nav-sub-ico"><i class="bi bi-card-list" aria-hidden="true"></i></span><span class="nav-sub-text">İlanlarım</span>
        </a>
        <a class="nav-sub-item<?= $active(['ilan-ekle.php']) ?>" href="ilan-ekle.php">
          <span class="nav-sub-ico"><i class="bi bi-plus-circle" aria-hidden="true"></i></span><span class="nav-sub-text">İlan Ekle</span>
        </a>
        <a class="nav-sub-item<?= $active(['one-cikar.php']) ?>" href="one-cikar.php">
          <span class="nav-sub-ico"><i class="bi bi-stars" aria-hidden="true"></i></span><span class="nav-sub-text">Öne Çıkar</span>
        </a>
      </div>
    </div>

    <div class="nav-group<?= $open($grpKredi) ?>">
      <button class="nav-group-btn" type="button" aria-expanded="<?= $isKrediOpen ? 'true' : 'false' ?>">
        <span class="nav-ico"><i class="bi bi-credit-card" aria-hidden="true"></i></span><span class="nav-text">Kredi Yönetimi</span><span class="nav-caret"><i class="bi bi-chevron-down" aria-hidden="true"></i></span>
      </button>
      <div class="nav-sub">
        <a class="nav-sub-item<?= $active(['kredi-yonetimi.php']) ?>" href="kredi-yonetimi.php">
          <span class="nav-sub-ico"><i class="bi bi-cart-plus" aria-hidden="true"></i></span><span class="nav-sub-text">Kredi Satın Al</span>
        </a>
        <a class="nav-sub-item<?= $active(['faturalar.php']) ?>" href="faturalar.php">
          <span class="nav-sub-ico"><i class="bi bi-receipt" aria-hidden="true"></i></span><span class="nav-sub-text">Faturalar / Ödeme Geçmişi</span>
        </a>
      </div>
    </div>

    <div class="nav-divider"></div>

    <div class="nav-group<?= $open($grpAyar) ?>">
      <button class="nav-group-btn" type="button" aria-expanded="<?= $isAyarOpen ? 'true' : 'false' ?>">
        <span class="nav-ico"><i class="bi bi-gear" aria-hidden="true"></i></span><span class="nav-text">Ayarlar</span><span class="nav-caret"><i class="bi bi-chevron-down" aria-hidden="true"></i></span>
      </button>
      <div class="nav-sub">
        <?php if ($isAdmin): ?>
          <a class="nav-sub-item<?= $active(['ilan-ayarlari.php']) ?>" href="ilan-ayarlari.php">
            <span class="nav-sub-ico"><i class="bi bi-sliders" aria-hidden="true"></i></span><span class="nav-sub-text">İlan Ayarları</span>
          </a>
          <a class="nav-sub-item<?= $active(['tesis-listesi.php']) ?>" href="tesis-listesi.php">
            <span class="nav-sub-ico"><i class="bi bi-buildings" aria-hidden="true"></i></span><span class="nav-sub-text">Tesis Listesi</span>
          </a>
        <?php endif; ?>
        <a class="nav-sub-item<?= $active(['tesis-ayarlari.php']) ?>" href="tesis-ayarlari.php">
          <span class="nav-sub-ico"><i class="bi bi-building-gear" aria-hidden="true"></i></span><span class="nav-sub-text">Tesis Ayarları</span>
        </a>
      </div>
    </div>

    <a class="nav-item nav-danger" href="cikis.php">
      <span class="nav-ico"><i class="bi bi-box-arrow-right" aria-hidden="true"></i></span><span class="nav-text">Çıkış Yap</span>
    </a>
  </nav>

  <div class="sidebar-bottom">
    <div class="sidebar-user">
      <div class="sidebar-user-avatar">
        <?php if ($profilFoto !== ''): ?>
          <img src="<?= e($profilFoto) ?>" alt="<?= e($tesisAdi) ?>">
        <?php else: ?>
          <span class="sidebar-user-initial"><?= e($initial) ?></span>
        <?php endif; ?>
      </div>
      <div class="sidebar-user-info">
        <div class="sidebar-user-name"><?= e($tesisAdi) ?></div>
        <div class="sidebar-user-meta">
          <span class="sidebar-user-kredi"><i class="bi bi-coin" aria-hidden="true"></i> Kredi: <?= $kredi ?></span>
        </div>
      </div>
    </div>
  </div>
</aside>
