// /home/bungalowsepeti/public_html/panel/js/ilan.js
(() => {
  "use strict";

  const qs = (s, r = document) => r.querySelector(s);
  const qsa = (s, r = document) => Array.from(r.querySelectorAll(s));

  window.BS = window.BS || {};
const BS = window.BS;
  const toast = (msg, type = "info", timeout = 3200) => BS?.toast?.(msg, type, timeout);

  /* ---------------------------
     UTIL (BS_UTIL varsa onu kullan)
  ----------------------------*/
  const getUtil = () => window.BS_UTIL || {};

  const toIntId = (x) => {
    const u = getUtil();
    if (u && typeof u.toIntId === "function") return u.toIntId(x);

    if (Number.isInteger(x) && x > 0) return x;
    if (typeof x === "number" && Number.isFinite(x)) {
      const n = Math.trunc(x);
      return n > 0 ? n : 0;
    }
    if (typeof x === "string") {
      const t = x.trim();
      if (!/^\d+$/.test(t)) return 0;
      const n = parseInt(t, 10);
      return Number.isInteger(n) && n > 0 ? n : 0;
    }
    return 0;
  };

  const uniqIntIds = (arr) => {
    const u = getUtil();
    if (u && typeof u.uniqIntIds === "function") return u.uniqIntIds(arr);

    const out = [];
    const seen = new Set();
    (arr || []).forEach((x) => {
      const id = toIntId(x);
      if (!id) return;
      if (seen.has(id)) return;
      seen.add(id);
      out.push(id);
    });
    return out;
  };

  const csvToIds = (csv) => {
    const u = getUtil();
    if (u && typeof u.csvToIds === "function") return u.csvToIds(csv);

    const s = String(csv || "").trim();
    if (!s) return [];
    return uniqIntIds(
      s
        .split(",")
        .map((p) => p.trim())
        .filter(Boolean)
    );
  };

  /* ---------------------------
     MINI MODAL
  ----------------------------*/
  function openMiniModal(html) {
    const overlay = document.createElement("div");
    overlay.className = "mini-modal-overlay";
    overlay.innerHTML = html;
    document.body.appendChild(overlay);

    const close = () => {
      if (overlay && overlay.parentNode) overlay.remove();
      document.removeEventListener("keydown", onKeyDown, true);
    };

    const onKeyDown = (e) => {
      if (e.key === "Escape") close();
    };

    document.addEventListener("keydown", onKeyDown, true);

    overlay.addEventListener("click", (e) => {
      if (e.target === overlay) close();
    });

    qs(".mini-modal-x", overlay)?.addEventListener("click", close);

    return { overlay, close };
  }

  function contractModal() {
    return new Promise((resolve) => {
      const { overlay, close } = openMiniModal(`
        <div class="mini-modal" role="dialog" aria-modal="true" style="max-width:760px;">
          <div class="mini-modal-hd">
            <div class="mini-modal-title">İlan Yayınlama Sözleşmesi</div>
            <button class="mini-modal-x" type="button" aria-label="Kapat">✕</button>
          </div>

          <div class="mini-modal-bd" style="padding:0;">
            <div id="bsContractScroll" style="max-height:56vh;overflow:auto;padding:14px;color:rgba(11,22,53,.80);font-size:13px;line-height:1.55;">
              <div style="font-weight:900;margin-bottom:8px;">Bilgilendirme</div>
              <ul style="margin:0 0 12px 18px;padding:0;">
                <li>İlanı incelemeye gönderdiğinde hesabından <b>100 kredi</b> düşer.</li>
                <li>İlanın <b>incelemeye alınır</b>, inceleme <b>en geç 24 saat</b> içinde tamamlanır.</li>
                <li>Metin ve görsellerin doğruluğundan ve kullanım hakkından ilan sahibi sorumludur.</li>
                <li>Gerekli görülürse düzeltme istenebilir veya ilan reddedilebilir.</li>
                <li>Kredi yetersizse ilan <b>taslak</b> olarak kaydedilir.</li>
              </ul>

              <div style="font-weight:900;margin:10px 0 8px;">Detay</div>
              <p>Bu sözleşme, BungalowSepeti paneli üzerinden oluşturulan ilanların yayın öncesi inceleme sürecini, içerik sorumluluğunu ve yayın koşullarını düzenler.</p>
              <p>1) İlan bilgileri (fiyat, kapasite, açıklamalar vb.) gerçeği yansıtmalıdır. Yanıltıcı bilgi tespiti halinde ilan yayından kaldırılabilir.</p>
              <p>2) Yüklenen görsellerin ve metinlerin kullanım hakkına sahip olduğunuzu kabul edersiniz.</p>
              <p>3) İlan incelemeye alındıktan sonra en geç 24 saat içinde değerlendirilir.</p>
              <p>4) İnceleme sonucunda ilan onaylanabilir, düzeltme istenebilir veya reddedilebilir.</p>
              <p>5) İlan incelemeye gönderim bedeli 100 kredidir. Kredi yetersizse ilan taslakta kalır.</p>
              <p>6) Platform; mevzuata aykırı, yanıltıcı veya uygunsuz içeriklerde gerekli işlemleri yapma hakkını saklı tutar.</p>

              <div style="height:70px;"></div>
              <div style="font-weight:900;">Bitti</div>
              <div style="font-size:12px;opacity:.85;">Onay butonu aktif olması için en alta kadar kaydırın.</div>
            </div>
          </div>

          <div class="mini-modal-ft">
            <button class="btn btn-ghost btn-sm mm-cancel" type="button">Vazgeç</button>
            <button class="btn btn-primary btn-sm mm-ok" type="button" disabled>Okudum, Onaylıyorum</button>
          </div>
        </div>
      `);

      const sc = qs("#bsContractScroll", overlay);
      const okBtn = qs(".mm-ok", overlay);
      const cancelBtn = qs(".mm-cancel", overlay);

      const checkScroll = () => {
        if (!sc || !okBtn) return;
        const atBottom = sc.scrollTop + sc.clientHeight >= sc.scrollHeight - 8;
        okBtn.disabled = !atBottom;
      };

      sc?.addEventListener("scroll", checkScroll);
      checkScroll();

      cancelBtn?.addEventListener("click", () => {
        close();
        resolve(false);
      });

      okBtn?.addEventListener("click", () => {
        close();
        resolve(true);
      });

      // erişilebilir başlangıç odağı
      (cancelBtn || okBtn || qs(".mini-modal-x", overlay))?.focus?.();
    });
  }

  function confirmSendModal({ needed = 100, credit = 0 } = {}) {
    return new Promise((resolve) => {
      let sozOk = false;

      const { overlay, close } = openMiniModal(`
        <div class="mini-modal" role="dialog" aria-modal="true" style="max-width:640px;">
          <div class="mini-modal-hd">
            <div class="mini-modal-title">İlanı İncelemeye Gönder</div>
            <button class="mini-modal-x" type="button" aria-label="Kapat">✕</button>
          </div>

          <div class="mini-modal-bd">
            <div>Bu işlemle hesabınızdan <b>${Number(needed) || 100} kredi</b> düşecektir. (Mevcut: <b>${Number(credit) || 0}</b>)</div>
            <div style="margin-top:8px;">İlanınız incelemeye alınacak ve inceleme <b>en geç 24 saat</b> içinde tamamlanacaktır.</div>

            <div style="margin-top:12px;padding:10px 12px;border:1px solid rgba(11,22,53,.12);border-radius:12px;background:rgba(11,22,53,.04);">
              <div style="font-weight:900;margin-bottom:6px;">Zorunlu</div>
              <div style="font-size:13px;line-height:1.45;">Devam edebilmek için sözleşmeyi okuyup onaylamalısınız.</div>

              <div style="margin-top:10px;display:flex;align-items:center;gap:10px;flex-wrap:wrap;">
                <button class="btn btn-ghost btn-sm mm-contract" type="button">Sözleşmeyi Oku</button>
                <span class="muted" id="mmSozTxt" style="font-size:12px;">Onay bekleniyor</span>
              </div>
            </div>
          </div>

          <div class="mini-modal-ft">
            <button class="btn btn-ghost btn-sm mm-cancel" type="button">Vazgeç</button>
            <button class="btn btn-primary btn-sm mm-ok" type="button" disabled>Onayla ve Gönder</button>
          </div>
        </div>
      `);

      const okBtn = qs(".mm-ok", overlay);
      const cancelBtn = qs(".mm-cancel", overlay);
      const sozBtn = qs(".mm-contract", overlay);
      const sozTxt = qs("#mmSozTxt", overlay);

      cancelBtn?.addEventListener("click", () => {
        close();
        resolve(false);
      });

      sozBtn?.addEventListener("click", async () => {
        const accepted = await contractModal();
        if (!accepted) return;
        sozOk = true;
        if (sozTxt) sozTxt.textContent = "Sözleşme onaylandı";
        if (okBtn) okBtn.disabled = false;
        okBtn?.focus?.();
      });

      okBtn?.addEventListener("click", () => {
        if (!sozOk) return;
        close();
        resolve(true);
      });

      cancelBtn?.focus?.();
    });
  }

  function insufficientCreditModal({ needed = 100, credit = 0 } = {}) {
    return new Promise((resolve) => {
      const { overlay, close } = openMiniModal(`
        <div class="mini-modal" role="dialog" aria-modal="true" style="max-width:560px;">
          <div class="mini-modal-hd">
            <div class="mini-modal-title">Yetersiz Kredi</div>
            <button class="mini-modal-x" type="button" aria-label="Kapat">✕</button>
          </div>

          <div class="mini-modal-bd">
            <div>İlanı incelemeye göndermek için en az <b>${Number(needed) || 100} kredi</b> gerekir.</div>
            <div style="margin-top:8px;">Mevcut krediniz: <b>${Number(credit) || 0}</b></div>
            <div style="margin-top:10px;">Devam ederseniz ilanınız <b>taslak</b> olarak kaydedilir ve kredi yönetimi sayfasına yönlendirilirsiniz.</div>
          </div>

          <div class="mini-modal-ft">
            <button class="btn btn-ghost btn-sm mm-cancel" type="button">Vazgeç</button>
            <button class="btn btn-primary btn-sm mm-ok" type="button">Kredi Yükle</button>
          </div>
        </div>
      `);

      qs(".mm-cancel", overlay)?.addEventListener("click", () => {
        close();
        resolve(false);
      });

      qs(".mm-ok", overlay)?.addEventListener("click", () => {
        close();
        resolve(true);
      });

      qs(".mm-ok", overlay)?.focus?.();
    });
  }

  /* ---------------------------
     İLAN FORM
  ----------------------------*/
  function initIlanEkle() {
    const form = qs(".ilan-form");
    if (!form) return;
    
    
    const waInp = qs('input[name="rez[13]"]', form);
  if (waInp) {
    waInp.setAttribute("inputmode", "numeric");
    waInp.setAttribute("maxlength", "11");
    waInp.setAttribute("autocomplete", "off");

    const clamp11 = () => {
      let d = String(waInp.value || "").replace(/\D+/g, "");
      if (d.length > 11) d = d.slice(0, 11);
      waInp.value = d;
    };

    waInp.addEventListener("input", clamp11);
    waInp.addEventListener("blur", clamp11);
    waInp.addEventListener("paste", () => setTimeout(clamp11, 0));

    waInp.addEventListener("keydown", (e) => {
      if (e.ctrlKey || e.metaKey || e.altKey) return;

      const k = e.key;
      const nav = ["Backspace","Delete","ArrowLeft","ArrowRight","Tab","Home","End"];
      if (nav.includes(k)) return;

      if (!/^\d$/.test(k)) { e.preventDefault(); return; }

      const d = String(waInp.value || "").replace(/\D+/g, "");
      const selLen = (waInp.selectionEnd ?? 0) - (waInp.selectionStart ?? 0);
      if (d.length >= 11 && selLen === 0) e.preventDefault();
    });

    clamp11();
  }
  
    const RULES = Object.assign(
      { minMulk: 3, minTesis: 3, minOda: 6, minGaleri: 6, maxGaleri: 10, krediMaliyet: 100 },
      window.BS_RULES || {}
    );

    const SECTION_ORDER = ["category", "features", "mulks", "tesis", "oda", "media", "distance", "rez"];
    const GATE_AFTER_CATEGORY = SECTION_ORDER.slice(1);

    const MSG = {
      category: "İlan Kategorisi seçmelisin.",
      features: "İlan Özellikleri: zorunlu alanları doğru formatta doldurmalısın.",
      mulks: `Mülk Tipleri: en az ${RULES.minMulk} seçim yapmalısın.`,
      tesis: `Tesis Özellikleri: en az ${RULES.minTesis} seçim yapmalısın.`,
      oda: `Oda Özellikleri: en az ${RULES.minOda} seçim yapmalısın.`,
      media: `İlan Görselleri: 1 kapak + en az ${RULES.minGaleri} galeri görseli seçmelisin.`,
      distance: "Mesafe Haritası: tüm alanları doldurmalı ve sayısal alanlara geçerli değer girmelisin.",
      rez: "Rezervasyon Linkleri: en az 1 adet geçerli link girmelisin.",
    };

    const card = (key) => qs(`.js-req-card[data-req="${key}"]`, form);

    /* ---------------------------
       Kategori gate (diğer bölümleri gizle)
    ----------------------------*/
    const lockAfterCategory = () => {
      GATE_AFTER_CATEGORY.forEach((k) => {
        const c = card(k);
        if (!c) return;
        c.classList.add("is-cat-locked");
        c.classList.remove("bs-reveal");
        c.style.animationDelay = "";
        c.style.display = "none";
      });
    };

    const revealAfterCategory = () => {
      GATE_AFTER_CATEGORY.forEach((k, idx) => {
        const c = card(k);
        if (!c) return;
        c.style.display = "";
        c.classList.remove("is-cat-locked");
        c.classList.remove("bs-reveal");
        void c.offsetWidth;
        c.style.animationDelay = `${idx * 70}ms`;
        c.classList.add("bs-reveal");
      });
    };

    let _wasCentered = false;

    const syncCategoryGate = () => {
      const ok = !!qs('input[name="ilan_turu_id"]:checked', form);
      if (!ok) {
        document.body.classList.add("is-cat-center");
        _wasCentered = true;
        lockAfterCategory();
        return;
      }

      document.body.classList.remove("is-cat-center");
      revealAfterCategory();

      if (_wasCentered) {
        _wasCentered = false;
        requestAnimationFrame(() => {
          requestAnimationFrame(() => window.scrollTo({ top: 0, behavior: "smooth" }));
        });
      }
    };

    qsa('input[name="ilan_turu_id"]', form).forEach((r) => {
      r.addEventListener("change", () => {
        syncCategoryGate();
        scheduleApply({ all: true });
      });
    });
    syncCategoryGate();

    /* ---------------------------
       INPUT helpers
    ----------------------------*/
    form.setAttribute("novalidate", "novalidate");

    const setInvalid = (el, msg) => {
      if (!el) return true;
      el.setCustomValidity(msg || "");
      return !msg;
    };

    const intValStrict = (raw) =>
      /^\d+$/.test(String(raw || "").trim()) ? parseInt(String(raw).trim(), 10) : null;

    const bindDigitsOnly = (el) => {
      if (!el) return;
      const clean = () => {
        const v = String(el.value || "");
        const nv = v.replace(/\D+/g, "");
        if (v !== nv) el.value = nv;
      };
      el.addEventListener("input", clean);
      el.addEventListener("blur", clean);
      el.addEventListener("paste", () => setTimeout(clean, 0));
    };

    const NUMERIC_FIELDS = [
      'input[name="fiyat"]',
      'input[name="indirimli_fiyat"]',
      'input[name="min_konaklama"]',
      'input[name="metrekare"]',
      'input[name="havaalani_mesafe"]',
      'input[name="plaj_mesafe"]',
      'input[name="otogar_mesafe"]',
      'input[name="market_mesafe"]',
      'input[name="sehir_merkezi_mesafe"]',
      'input[name="restaurant_mesafe"]',
    ];
    NUMERIC_FIELDS.forEach((sel) => bindDigitsOnly(qs(sel, form)));

    const fiyatEl = qs('input[name="fiyat"]', form);
    const indEl = qs('input[name="indirimli_fiyat"]', form);

    const DIST_FIELDS = [
      ["havaalani_mesafe", "Havalimanı mesafesi zorunlu."],
      ["plaj_mesafe", "Plaj mesafesi zorunlu."],
      ["otogar_mesafe", "Otogar mesafesi zorunlu."],
      ["market_mesafe", "Market mesafesi zorunlu."],
      ["sehir_merkezi_mesafe", "Şehir merkezi mesafesi zorunlu."],
      ["restaurant_mesafe", "Restaurant mesafesi zorunlu."],
    ];

    /* ---------------------------
       Media read helpers
    ----------------------------*/
    const coverInp = qs("#cover_media_id", form);
    const galInp = qs("#gallery_media_ids", form);

    const readMediaInputs = () => {
      const coverId = toIntId(coverInp?.value || "");
      let galIds = csvToIds(galInp?.value || "");
      if (coverId) galIds = galIds.filter((id) => id !== coverId);
      galIds = uniqIntIds(galIds).slice(0, RULES.maxGaleri);
      return { coverId, galIds };
    };

    const checkedCount = (sel) => qsa(sel, form).length;

    /* ---------------------------
       Validation: numeric, distance, rez
    ----------------------------*/
    const validateNumericInputs = () => {
      let ok = true;

      // fiyat
      const fiyatRaw = String(fiyatEl?.value || "").trim();
      const fiyat = intValStrict(fiyatRaw);
      if (fiyatEl) {
        if (fiyatRaw === "") ok = setInvalid(fiyatEl, "Fiyat zorunlu.") && ok;
        else if (fiyat === null || fiyat <= 0) ok = setInvalid(fiyatEl, "Fiyat sayısal olmalı.") && ok;
        else ok = setInvalid(fiyatEl, "") && ok;
      }

      // indirimli fiyat
      const indRaw = String(indEl?.value || "").trim();
      if (indEl) {
        if (indRaw === "") {
          ok = setInvalid(indEl, "") && ok;
        } else {
          const ind = intValStrict(indRaw);
          const fiyatNow = intValStrict(String(fiyatEl?.value || "").trim());
          if (ind === null) ok = setInvalid(indEl, "İndirimli fiyat sayısal olmalı.") && ok;
          else if (!fiyatNow || fiyatNow <= 0) ok = setInvalid(indEl, "Önce normal fiyat giriniz.") && ok;
          else if (ind >= fiyatNow) ok = setInvalid(indEl, "İndirimli fiyat, normal fiyattan küçük olmalı.") && ok;
          else ok = setInvalid(indEl, "") && ok;
        }
      }

      // min konaklama
      const mkEl = qs('input[name="min_konaklama"]', form);
      const mkRaw = String(mkEl?.value || "").trim();
      const mk = intValStrict(mkRaw);
      if (mkEl) {
        if (mkRaw === "") ok = setInvalid(mkEl, "Minimum konaklama zorunlu.") && ok;
        else if (mk === null || mk < 1 || mk > 255) ok = setInvalid(mkEl, "Minimum konaklama 1-255 olmalı.") && ok;
        else ok = setInvalid(mkEl, "") && ok;
      }

      // metrekare
      const m2El = qs('input[name="metrekare"]', form);
      const m2Raw = String(m2El?.value || "").trim();
      const m2 = intValStrict(m2Raw);
      if (m2El) {
        if (m2Raw === "") ok = setInvalid(m2El, "m² bilgisi zorunlu.") && ok;
        else if (m2 === null || m2 <= 0) ok = setInvalid(m2El, "m² bilgisi sayısal olmalı.") && ok;
        else ok = setInvalid(m2El, "") && ok;
      }

      return ok;
    };

    const validateDistanceSection = () => {
      let ok = true;

      const haEl = qs('[name="havaalani_ismi"]', form);
      const haVal = String(haEl?.value || "").trim();
      if (haEl) {
        if (haVal === "") ok = setInvalid(haEl, "En yakın havalimanı ismi zorunlu.") && ok;
        else ok = setInvalid(haEl, "") && ok;
      }

      DIST_FIELDS.forEach(([name, reqMsg]) => {
        const el = qs(`[name="${name}"]`, form);
        if (!el) return;

        const raw = String(el.value || "").trim();
        const v = intValStrict(raw);

        if (raw === "") ok = setInvalid(el, reqMsg) && ok;
        else if (v === null || v <= 0) ok = setInvalid(el, "Geçerli bir mesafe girin (örn: 25).") && ok;
        else ok = setInvalid(el, "") && ok;
      });

      return ok;
    };

    const isIPv4 = (h) => {
      if (!/^\d{1,3}(\.\d{1,3}){3}$/.test(h)) return false;
      return h.split(".").every((p) => {
        const n = Number(p);
        return Number.isInteger(n) && n >= 0 && n <= 255;
      });
    };

    const isDomain = (h) => {
      if (!h) return false;
      if (h.length > 253) return false;
      if (h.includes("_")) return false;
      if (h.startsWith(".") || h.endsWith(".")) return false;

      const parts = h.split(".");
      if (parts.length < 2) return false;
      for (const p of parts) {
        if (!p || p.length > 63) return false;
        if (!/^[a-z0-9-]+$/i.test(p)) return false;
        if (p.startsWith("-") || p.endsWith("-")) return false;
      }
      const tld = parts[parts.length - 1];
      if (tld.length < 2) return false;
      return true;
    };

    const isHttpUrlStrict = (s) => {
      const v = String(s || "").trim();
      if (v === "") return false;
      if (/[<>]/.test(v)) return false;
      if (/\s/.test(v)) return false;
      if (!/^https?:\/\//i.test(v)) return false;

      try {
        const u = new URL(v);
        if (!(u.protocol === "http:" || u.protocol === "https:")) return false;
        const host = String(u.hostname || "").trim();
        if (!host) return false;
        if (host === "localhost") return true;
        if (isIPv4(host)) return true;
        return isDomain(host);
      } catch {
        return false;
      }
    };

   const rezIsValid = (v, pid = 0) => {
  const raw = String(v || "").trim();
  if (raw === "") return false;
  if (/[<>]/.test(raw)) return false;

  const cleaned = raw.replace(/[\x00-\x1F\x7F]/g, "");

  // WhatsApp Rezervasyon (id: 13) -> 11 haneli telefon kabul
if (Number(pid) === 13) {
  if (/^https?:\/\//i.test(cleaned)) return isHttpUrlStrict(cleaned);

  const digits = cleaned.replace(/\D/g, "");
  return /^0\d{10}$/.test(digits); // sadece 11 hane (0 ile başlayan)
}


  // Diğer platformlar: URL veya genel telefon (eski davranış)
  if (/^https?:\/\//i.test(cleaned)) return isHttpUrlStrict(cleaned);

  const phone = cleaned.replace(/[^\d+]/g, "");
  const digits = phone.replace(/\D/g, "");
  return !!(digits && digits.length >= 8 && digits.length <= 20);
};

    const validateRezInputs = () => {
      let ok = true;
      const inputs = qsa('input[name^="rez["]', form);
      let hasAny = false;

      inputs.forEach((el) => {
        const raw = String(el.value || "").trim();

        if (raw === "") {
          el.setCustomValidity("");
          return;
        }

        hasAny = true;

        const m = String(el.name || "").match(/^rez\[(\d+)\]/);
const pid = m ? parseInt(m[1], 10) : 0;

if (!rezIsValid(raw, pid)) {
          el.setCustomValidity("Rezervasyon linki hatalı.");
          ok = false;
        } else {
          el.setCustomValidity("");
        }
      });

      if (!hasAny) ok = false;
      return ok;
    };

    /* ---------------------------
       Section rules (gate dahil)
    ----------------------------*/
    const isCategoryOk = () => !!qs('input[name="ilan_turu_id"]:checked', form);
    const isGateOpen = () => isCategoryOk();

    const rules = {
      category: () => isCategoryOk(),
      features: () => {
        if (!isGateOpen()) return true;

        const c = card("features");
        if (!c) return true;

        // Numeric ve select validity'leri burada devrede
        let ok = true;
        const requiredControls = qsa("input,select,textarea", c).filter((el) => el.hasAttribute("required"));

        requiredControls.forEach((el) => {
          if (typeof el.checkValidity === "function") {
            if (!el.checkValidity()) ok = false;
          } else {
            if (String(el.value || "").trim() === "") ok = false;
          }
        });

        return ok;
      },
      mulks: () => (!isGateOpen() ? true : checkedCount('input[name="mulktipleri[]"]:checked') >= RULES.minMulk),
      tesis: () => (!isGateOpen() ? true : checkedCount('input[name="tesis_ozellikleri[]"]:checked') >= RULES.minTesis),
      oda: () => (!isGateOpen() ? true : checkedCount('input[name="oda_ozellikleri[]"]:checked') >= RULES.minOda),
      media: () => {
        if (!isGateOpen()) return true;
        const { coverId, galIds } = readMediaInputs();
        return coverId > 0 && galIds.length >= RULES.minGaleri && galIds.length <= RULES.maxGaleri;
      },
      distance: () => (!isGateOpen() ? true : cache.distOk),
      rez: () => (!isGateOpen() ? true : cache.rezOk),
    };

    /* ---------------------------
       Cache + apply (kısmi)
    ----------------------------*/
    const cache = {
      numericOk: true,
      distOk: true,
      rezOk: true,
    };

    const recomputeSectionStates = () => {
      let allOk = true;

      SECTION_ORDER.forEach((k) => {
        const ok = !!rules[k]?.();
        const c = card(k);
        if (c) c.classList.toggle("is-done", ok);
        if (c && c.classList.contains("is-error") && ok) c.classList.remove("is-error");
        allOk = allOk && ok;
      });

      return allOk;
    };

    const apply = ({ numeric = false, distance = false, rez = false, all = false } = {}) => {
      if (all || numeric) cache.numericOk = validateNumericInputs();
      if (all || distance) cache.distOk = validateDistanceSection();
      if (all || rez) cache.rezOk = validateRezInputs();

      // features validity, numeric validity ile birlikte çalışıyor
      return recomputeSectionStates();
    };

    // upload.js burayı çağırıyor (hidden inputlar değişince)
    const scheduleApply = (() => {
      let raf = 0;
      const pending = { numeric: false, distance: false, rez: false, all: false };

      const flush = () => {
        raf = 0;
        const p = Object.assign({}, pending);
        pending.numeric = pending.distance = pending.rez = pending.all = false;
        apply(p);
      };

      return (opts = {}) => {
        if (opts.all) pending.all = true;
        if (opts.numeric) pending.numeric = true;
        if (opts.distance) pending.distance = true;
        if (opts.rez) pending.rez = true;

        if (raf) return;
        raf = requestAnimationFrame(flush);
      };
    })();

    // dışarıdan tetikleme (upload.js)
    BS.updateIlanCards = () => scheduleApply({ all: true });

    /* ---------------------------
       İndirim kuralı (UX)
    ----------------------------*/
    let _lastWarn = 0;
    const warn = (msg) => {
      const now = Date.now();
      if (now - _lastWarn < 1200) return;
      _lastWarn = now;
      toast(msg, "error", 3200);
    };

    const enforceDiscount = () => {
      if (!indEl) return;

      const rawInd = String(indEl.value || "").trim();
      if (rawInd === "") {
        scheduleApply({ numeric: true });
        return;
      }

      const fiyat = intValStrict(fiyatEl?.value);
      const ind = intValStrict(rawInd);

      if (!fiyat || fiyat <= 0) {
        indEl.value = "";
        warn("Önce normal fiyat giriniz.");
        fiyatEl?.focus?.();
      } else if (ind !== null && ind >= fiyat) {
        warn("İndirimli fiyat, normal fiyattan küçük olmalı.");
      }

      scheduleApply({ numeric: true });
    };

    if (indEl) {
      indEl.addEventListener("focus", () => {
        const fiyat = intValStrict(fiyatEl?.value);
        if (!fiyat || fiyat <= 0) {
          warn("Önce normal fiyat giriniz.");
          setTimeout(() => fiyatEl?.focus?.(), 0);
        }
      });
      indEl.addEventListener("input", enforceDiscount);
      indEl.addEventListener("change", enforceDiscount);
      indEl.addEventListener("blur", enforceDiscount);
    }

    if (fiyatEl) {
      fiyatEl.addEventListener("input", () => {
        if (String(indEl?.value || "").trim() !== "") enforceDiscount();
        else scheduleApply({ numeric: true });
      });
      fiyatEl.addEventListener("change", () => {
        if (String(indEl?.value || "").trim() !== "") enforceDiscount();
        else scheduleApply({ numeric: true });
      });
    }

    /* ---------------------------
       Form event -> kısmi apply
    ----------------------------*/
    const isNumericTarget = (t) => {
      if (!t || !t.name) return false;
      return [
        "fiyat",
        "indirimli_fiyat",
        "min_konaklama",
        "metrekare",
        "havaalani_mesafe",
        "plaj_mesafe",
        "otogar_mesafe",
        "market_mesafe",
        "sehir_merkezi_mesafe",
        "restaurant_mesafe",
      ].includes(String(t.name));
    };

    const isDistanceTarget = (t) => {
      if (!t || !t.name) return false;
      if (String(t.name) === "havaalani_ismi") return true;
      return DIST_FIELDS.some(([n]) => n === String(t.name));
    };

    const isRezTarget = (t) => {
      if (!t || !t.name) return false;
      return String(t.name).startsWith("rez[");
    };

    form.addEventListener(
      "input",
      (e) => {
        const t = e.target;
        scheduleApply({
          numeric: isNumericTarget(t),
          distance: isDistanceTarget(t),
          rez: isRezTarget(t),
        });
      },
      true
    );

    form.addEventListener(
      "change",
      (e) => {
        const t = e.target;
        scheduleApply({
          numeric: isNumericTarget(t),
          distance: isDistanceTarget(t),
          rez: isRezTarget(t),
        });
      },
      true
    );

    /* ---------------------------
       Submit
    ----------------------------*/
    let _bypassSubmit = false;

    form.addEventListener("submit", async (e) => {
      const okAll = apply({ all: true });

      if (!okAll) {
        const firstBad = SECTION_ORDER.find((k) => !rules[k]?.());
        const c = firstBad ? card(firstBad) : null;

        if (c) {
          c.classList.add("is-error");
          c.scrollIntoView({ behavior: "smooth", block: "start" });

          const controls = Array.from(c.querySelectorAll("input,select,textarea"));
          const firstInvalid = controls.find((el) => typeof el.checkValidity === "function" && !el.checkValidity());
          const target = firstInvalid || controls[0];
          if (target) setTimeout(() => { try { target.focus(); } catch {} }, 80);
        }

        toast(MSG[firstBad] || "Eksik / hatalı alanlar var.", "error", 12222);
        e.preventDefault();
        return;
      }

      if (_bypassSubmit || form.dataset.bsConfirm === "1") return;

      const ctxEdit = window.BS_ILAN_CONTEXT || null;
      const ctxCreate = window.BS_ILAN || null;

      const isEdit = !!(ctxEdit && String(ctxEdit.page || "") === "ilan-duzenle");
      const yd = String(ctxEdit.yayin_durumu || "");
const isCreditFlowEdit = isEdit && (yd === "taslak" || yd === "suresi-bitti");

// yayında/pasif/incelemede düzenlemelerde (taslak / suresi-bitti değilse) confirm akışına girme
if (isEdit && !isCreditFlowEdit) return;

      e.preventDefault();

      const needed = Number((isEdit ? ctxEdit?.needed : ctxCreate?.needed) || RULES.krediMaliyet || 100);
      const credit = Number((isEdit ? ctxEdit?.kredi : ctxCreate?.credit) || 0);

      const draftInp = qs("#save_as_draft", form);
      const sozInpCreate = qs("#sozlesme_onay", form);
      const sozInpEdit = qs("#sozlesme_ok", form);

      // Kredi yetersiz -> taslak kaydet + yönlendirme (backend zaten yönlendiriyor)
      if (credit < needed) {
        const go = await insufficientCreditModal({ needed, credit });
        if (!go) return;

        if (draftInp) draftInp.value = "1";
        if (sozInpCreate) sozInpCreate.value = "";
        if (sozInpEdit) sozInpEdit.value = "0";

        form.dataset.bsConfirm = "1";
        _bypassSubmit = true;
        form.submit();
        return;
      }

      // Kredi yeterli -> sözleşme modalı + onay
      if (draftInp) draftInp.value = "0";
      if (sozInpCreate) sozInpCreate.value = "";
      if (sozInpEdit) sozInpEdit.value = "0";

      const yes = await confirmSendModal({ needed, credit });
      if (!yes) return;

      if (sozInpCreate) sozInpCreate.value = "1";
      if (sozInpEdit) sozInpEdit.value = "1";

      form.dataset.bsConfirm = "1";
      _bypassSubmit = true;
      form.submit();
    });

    // ilk render
    apply({ all: true });
  }

  document.addEventListener("DOMContentLoaded", () => {
    initIlanEkle();
  });

  // dışa aktar
Object.assign(window.BS, {
  contractModal,
  confirmSendModal,
  insufficientCreditModal,
});

})();
