<?php
// panel/index.php
require_once __DIR__ . '/init.php';

require_login();
auth_refresh_user();

$u = current_user();
$isAdmin = (($u['rol'] ?? '') === 'admin');

$tesisId = (int)($u['id'] ?? 0);

function fetch_count(string $sql, array $params = []): int {
    $st = db()->prepare($sql);
    $st->execute($params);
    return (int)$st->fetchColumn();
}

$params = $isAdmin ? [] : [':tesis_id' => $tesisId];
$whereTesis = $isAdmin ? '' : ' WHERE tesis_id = :tesis_id ';

$totalIlan = fetch_count("SELECT COUNT(*) FROM ilanlar {$whereTesis}", $params);
$yayinda = fetch_count("SELECT COUNT(*) FROM ilanlar {$whereTesis} " . ($isAdmin ? "WHERE" : "AND") . " yayin_durumu = 'yayinda'", $params);
$yayindaDegil = fetch_count("SELECT COUNT(*) FROM ilanlar {$whereTesis} " . ($isAdmin ? "WHERE" : "AND") . " yayin_durumu = 'yayinda-degil'", $params);

$oneCikarAktif = fetch_count(
    "SELECT COUNT(*) FROM one_cikarilan_ilanlar " . ($isAdmin ? "" : "WHERE tesis_id = :tesis_id AND ") . ($isAdmin ? "WHERE " : "") . " NOW() >= baslangic_tarih AND NOW() < bitis_tarih",
    $isAdmin ? [] : [':tesis_id' => $tesisId]
);

$sonIlanlarSql = "SELECT id, oda_ismi, yayin_durumu, created_at FROM ilanlar {$whereTesis} ORDER BY id DESC LIMIT 6";
$st = db()->prepare($sonIlanlarSql);
$st->execute($params);
$sonIlanlar = $st->fetchAll();
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Panel</title>
</head>
<body class="panel-body">


  <div class="panel-shell">
    <?php include __DIR__ . '/sidebar.php'; ?>

    <div class="panel-main">
      <header class="topbar">

        <div class="topbar-title">
          <div class="topbar-h1">Anasayfa</div>
          <div class="topbar-sub muted"><?= $isAdmin ? 'Yönetici Paneli' : 'Tesis Paneli' ?></div>
        </div>

        <div class="topbar-right">
          <div class="pill">
            <span class="muted">Kredi</span>
            <span class="pill-strong"><?= (int)($u['kredi_puani'] ?? 0) ?></span>
          </div>
          <a class="btn btn-ghost btn-sm" href="hesap-yonetimi.php">Hesabım</a>
        </div>
      </header>

      <main class="content">
        <section class="cards">
          <a class="dash-card" href="ilanlarim.php">
            <div class="dash-card-top"><span class="dash-ico">📦</span><span class="muted">Toplam İlan</span></div>
            <div class="dash-num"><?= $totalIlan ?></div>
          </a>

          <a class="dash-card" href="ilanlarim.php">
            <div class="dash-card-top"><span class="dash-ico">🟢</span><span class="muted">Yayında</span></div>
            <div class="dash-num"><?= $yayinda ?></div>
          </a>

          <a class="dash-card" href="ilanlarim.php">
            <div class="dash-card-top"><span class="dash-ico">⚪</span><span class="muted">Yayında Değil</span></div>
            <div class="dash-num"><?= $yayindaDegil ?></div>
          </a>

          <a class="dash-card" href="one-cikar.php">
            <div class="dash-card-top"><span class="dash-ico">⭐</span><span class="muted">Aktif Öne Çıkan</span></div>
            <div class="dash-num"><?= $oneCikarAktif ?></div>
          </a>
        </section>

        <section class="panel-section">
          <div class="section-head">
            <div class="section-title">Son İlanlar</div>
            <a class="link" href="ilanlarim.php">Tümünü gör</a>
          </div>

          <div class="table">
            <div class="tr th">
              <div class="td">İlan</div>
              <div class="td">Durum</div>
              <div class="td td-right">Tarih</div>
            </div>

            <?php if (!$sonIlanlar): ?>
              <div class="tr">
                <div class="td muted">Henüz ilan yok.</div>
                <div class="td"></div>
                <div class="td"></div>
              </div>
            <?php else: ?>
              <?php foreach ($sonIlanlar as $row): ?>
                <div class="tr">
                  <div class="td">
                    <a class="link" href="ilan-duzenle.php?id=<?= (int)$row['id'] ?>">
                      <?= e((string)($row['oda_ismi'] ?? 'İsimsiz İlan')) ?>
                    </a>
                  </div>
                  <div class="td">
                    <span class="badge"><?= e((string)($row['yayin_durumu'] ?? '')) ?></span>
                  </div>
                  <div class="td td-right muted"><?= e((string)($row['created_at'] ?? '')) ?></div>
                </div>
              <?php endforeach; ?>
            <?php endif; ?>
          </div>
        </section>
      </main>
    </div>
  </div>

</body>
</html>
