<?php
// panel/auth.php

declare(strict_types=1);

function auth_login(string $email, string $password): bool {
    $email = trim(mb_strtolower($email));
    if ($email === '' || $password === '') return false;

    $stmt = db()->prepare("SELECT id, rol, tesis_ismi, email, password, kredi_puani FROM tesisler WHERE email = :email LIMIT 1");
    $stmt->execute([':email' => $email]);
    $user = $stmt->fetch();

    // sabit süreye yakın davranış için (kullanıcı yoksa da verify çalışsın)
    $hash = is_array($user) ? (string)($user['password'] ?? '') : password_hash('dummy', PASSWORD_DEFAULT);
    $ok = password_verify($password, $hash);

    if (!$ok || !is_array($user)) return false;

    session_regenerate_id(true);

    $_SESSION['user'] = [
        'id' => (int)$user['id'],
        'rol' => (string)$user['rol'],
        'tesis_ismi' => (string)$user['tesis_ismi'],
        'email' => (string)$user['email'],
        'kredi_puani' => (int)$user['kredi_puani'],
    ];

    return true;
}

function auth_logout(): void {
    $_SESSION = [];

    if (ini_get('session.use_cookies')) {
        $p = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000, $p['path'], $p['domain'], (bool)$p['secure'], (bool)$p['httponly']);
    }

    session_destroy();
}

function auth_refresh_user(): void {
    $u = current_user();
    if (!$u) return;

    $stmt = db()->prepare("SELECT id, rol, tesis_ismi, email, kredi_puani FROM tesisler WHERE id = :id LIMIT 1");
    $stmt->execute([':id' => (int)$u['id']]);
    $fresh = $stmt->fetch();

    if (!$fresh) {
        auth_logout();
        redirect('giris.php');
    }

    $_SESSION['user'] = [
        'id' => (int)$fresh['id'],
        'rol' => (string)$fresh['rol'],
        'tesis_ismi' => (string)$fresh['tesis_ismi'],
        'email' => (string)$fresh['email'],
        'kredi_puani' => (int)$fresh['kredi_puani'],
    ];
}
